from VisualInterface import *
from NumericInterface import *
from DataInterface import *

from Visuals import *
from Numerics import *
from DataOut import *


nSpinsX = 9
nSpinsY = 12

k = pi*vector(1.0/3.0,1.0/3.0,0.0)
zArray = [[1.0,-1.0],[-1.0,1.0],[1.0,-1.0]]
phaseArray = [[1.0,1.0],[1.0,1.0],[1.0,1.0]]
phiArray = [[1.0,1.0],[1.0,1.0],[1.0,1.0]]

phiScale = 0.15

Ja = -1.0
Jbx = 1.6
Jby = -2.0
Jad = -1.0

trackSpins = [(0,0)]
dt = .005



visuals = Visuals(nSpinsX, nSpinsY)
numerics = Numerics(nSpinsX, nSpinsY, k, zArray, phaseArray, phiArray, phiScale, Ja, Jbx, Jby, Jad, dt, visuals)
dataOut = DataOut(trackSpins, numerics)

visualTk = Tk()
numericTk = Tk()
dataTk = Tk()

visualInterface = VisualInterface(visualTk, visuals)
numericInterface = NumericInterface(numericTk, numerics)
dataInterface = DataInterface(dataTk, dataOut)


visualTk.mainloop()
numericTk.mainloop()
dataTk.mainloop()



